/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.dos33;

import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.TextBundle;

public class OzDosFormatDisk
extends DosFormatDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int OZDOS_DISK_1 = 0;
    public static final int OZDOS_DISK_2 = 256;
    private int logicalOffset;

    public OzDosFormatDisk(String filename, ImageOrder imageOrder, int logicalOffset) {
        super(filename, imageOrder);
        this.logicalOffset = logicalOffset;
    }

    public static DosFormatDisk[] create(String filename, ImageOrder imageOrder) {
        OzDosFormatDisk disk1 = new OzDosFormatDisk(filename, imageOrder, 0);
        OzDosFormatDisk disk2 = new OzDosFormatDisk(filename, imageOrder, 256);
        disk1.format();
        disk2.format();
        return new OzDosFormatDisk[]{disk1, disk2};
    }

    @Override
    public String getDiskName() {
        if (this.logicalOffset == 0) {
            return this.textBundle.format("DiskNameN", super.getDiskName(), 1);
        }
        if (this.logicalOffset == 256) {
            return this.textBundle.format("DiskNameN", super.getDiskName(), 2);
        }
        return super.getDiskName();
    }

    @Override
    public int getLogicalDiskNumber() {
        if (this.logicalOffset == 0) {
            return 1;
        }
        if (this.logicalOffset == 256) {
            return 2;
        }
        return 0;
    }

    @Override
    public void format() {
        int tracksPerDisk = 50;
        int sectorsPerTrack = 32;
        int firstCatalogSector = 31;
        byte[] data = new byte[256];
        for (int t = 0; t < 50; ++t) {
            for (int s = 0; s < 32; ++s) {
                this.writeSector(t, s, data);
            }
        }
        this.format(31, 50, 32);
    }

    @Override
    public byte[] readSector(int track, int sector) throws IllegalArgumentException {
        byte[] blockData = this.readBlock(this.getBlockNumber(track, sector));
        byte[] sectorData = new byte[256];
        System.arraycopy(blockData, this.logicalOffset, sectorData, 0, 256);
        return sectorData;
    }

    @Override
    public void writeSector(int track, int sector, byte[] bytes) throws IllegalArgumentException {
        int blockNumber = this.getBlockNumber(track, sector);
        byte[] blockData = this.readBlock(blockNumber);
        System.arraycopy(bytes, 0, blockData, this.logicalOffset, 256);
        this.getImageOrder().writeBlock(blockNumber, blockData);
    }

    protected int getBlockNumber(int track, int sector) {
        return track * 32 + sector;
    }
}

